<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

$response = array();

if (!empty($data->user_id) && !empty($data->old_password) && !empty($data->new_password)) {
    
    // Get current password
    $query = "SELECT password FROM users WHERE id = :user_id";
    $stmt = $db->prepare($query);
    $stmt->bindParam(":user_id", $data->user_id);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Verify old password
        if (password_verify($data->old_password, $row['password'])) {
            
            // Update to new password
            $new_password_hash = password_hash($data->new_password, PASSWORD_DEFAULT);
            $update_query = "UPDATE users SET password = :password WHERE id = :user_id";
            $update_stmt = $db->prepare($update_query);
            $update_stmt->bindParam(":password", $new_password_hash);
            $update_stmt->bindParam(":user_id", $data->user_id);
            
            if ($update_stmt->execute()) {
                $response['success'] = true;
                $response['message'] = "Password berhasil diubah";
                http_response_code(200);
            } else {
                $response['success'] = false;
                $response['message'] = "Gagal mengubah password";
                http_response_code(500);
            }
            
        } else {
            $response['success'] = false;
            $response['message'] = "Password lama tidak sesuai";
            http_response_code(401);
        }
        
    } else {
        $response['success'] = false;
        $response['message'] = "User tidak ditemukan";
        http_response_code(404);
    }
    
} else {
    $response['success'] = false;
    $response['message'] = "Data tidak lengkap";
    http_response_code(400);
}

echo json_encode($response);
?>
