<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

$response = array();

if (!empty($data->username) && !empty($data->password)) {
    $query = "SELECT id, nama_lengkap, username, email, password, phone, address, role, profile_image FROM users WHERE username = :username OR email = :username";
    $stmt = $db->prepare($query);
    $stmt->bindParam(":username", $data->username);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (password_verify($data->password, $row['password'])) {
            $response['success'] = true;
            $response['message'] = "Login berhasil";
            $response['data'] = array(
                "id" => $row['id'],
                "nama_lengkap" => $row['nama_lengkap'],
                "username" => $row['username'],
                "email" => $row['email'],
                "phone" => $row['phone'],
                "address" => $row['address'],
                "role" => $row['role'],
                "profile_image" => $row['profile_image']
            );
            http_response_code(200);
        } else {
            $response['success'] = false;
            $response['message'] = "Password salah";
            http_response_code(401);
        }
    } else {
        $response['success'] = false;
        $response['message'] = "Username atau email tidak ditemukan";
        http_response_code(404);
    }
} else {
    $response['success'] = false;
    $response['message'] = "Data tidak lengkap";
    http_response_code(400);
}

echo json_encode($response);
?>
