<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

$response = array();

if (!empty($data->nama_lengkap) && !empty($data->username) && !empty($data->email) && !empty($data->password)) {
    
    // Check if username or email already exists
    $check_query = "SELECT id FROM users WHERE username = :username OR email = :email";
    $check_stmt = $db->prepare($check_query);
    $check_stmt->bindParam(":username", $data->username);
    $check_stmt->bindParam(":email", $data->email);
    $check_stmt->execute();
    
    if ($check_stmt->rowCount() > 0) {
        $response['success'] = false;
        $response['message'] = "Username atau email sudah terdaftar";
        http_response_code(409);
    } else {
        $query = "INSERT INTO users (nama_lengkap, username, email, password, phone, address, role, login_type) 
                  VALUES (:nama_lengkap, :username, :email, :password, :phone, :address, 'user', :login_type)";
        
        $stmt = $db->prepare($query);
        
        $hashed_password = password_hash($data->password, PASSWORD_DEFAULT);
        $phone = isset($data->phone) ? $data->phone : null;
        $address = isset($data->address) ? $data->address : null;
        $login_type = isset($data->login_type) ? $data->login_type : 'normal';
        
        $stmt->bindParam(":nama_lengkap", $data->nama_lengkap);
        $stmt->bindParam(":username", $data->username);
        $stmt->bindParam(":email", $data->email);
        $stmt->bindParam(":password", $hashed_password);
        $stmt->bindParam(":phone", $phone);
        $stmt->bindParam(":address", $address);
        $stmt->bindParam(":login_type", $login_type);
        
        if ($stmt->execute()) {
            $user_id = $db->lastInsertId();
            
            $response['success'] = true;
            $response['message'] = "Registrasi berhasil";
            $response['data'] = array(
                "id" => $user_id,
                "nama_lengkap" => $data->nama_lengkap,
                "username" => $data->username,
                "email" => $data->email,
                "phone" => $phone,
                "address" => $address,
                "role" => "user"
            );
            http_response_code(201);
        } else {
            $response['success'] = false;
            $response['message'] = "Registrasi gagal";
            http_response_code(500);
        }
    }
} else {
    $response['success'] = false;
    $response['message'] = "Data tidak lengkap";
    http_response_code(400);
}

echo json_encode($response);
?>
