<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

$response = array();

if (!empty($data->social_id) && !empty($data->login_type) && !empty($data->email)) {
    
    // Check if user exists with this social_id
    $query = "SELECT id, nama_lengkap, username, email, phone, address, role, profile_image FROM users WHERE social_id = :social_id AND login_type = :login_type";
    $stmt = $db->prepare($query);
    $stmt->bindParam(":social_id", $data->social_id);
    $stmt->bindParam(":login_type", $data->login_type);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        // User exists, login
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $response['success'] = true;
        $response['message'] = "Login berhasil";
        $response['data'] = array(
            "id" => $row['id'],
            "nama_lengkap" => $row['nama_lengkap'],
            "username" => $row['username'],
            "email" => $row['email'],
            "phone" => $row['phone'],
            "address" => $row['address'],
            "role" => $row['role'],
            "profile_image" => $row['profile_image']
        );
        http_response_code(200);
    } else {
        // Create new user
        $nama_lengkap = $data->nama_lengkap ?? $data->email;
        $username = explode('@', $data->email)[0] . '_' . substr($data->social_id, 0, 5);
        $password = password_hash(bin2hex(random_bytes(16)), PASSWORD_DEFAULT);
        $profile_image = $data->profile_image ?? null;
        
        $insert_query = "INSERT INTO users (nama_lengkap, username, email, password, role, login_type, social_id, profile_image) 
                        VALUES (:nama_lengkap, :username, :email, :password, 'user', :login_type, :social_id, :profile_image)";
        $insert_stmt = $db->prepare($insert_query);
        $insert_stmt->bindParam(":nama_lengkap", $nama_lengkap);
        $insert_stmt->bindParam(":username", $username);
        $insert_stmt->bindParam(":email", $data->email);
        $insert_stmt->bindParam(":password", $password);
        $insert_stmt->bindParam(":login_type", $data->login_type);
        $insert_stmt->bindParam(":social_id", $data->social_id);
        $insert_stmt->bindParam(":profile_image", $profile_image);
        
        if ($insert_stmt->execute()) {
            $user_id = $db->lastInsertId();
            $response['success'] = true;
            $response['message'] = "Login berhasil (akun baru dibuat)";
            $response['data'] = array(
                "id" => $user_id,
                "nama_lengkap" => $nama_lengkap,
                "username" => $username,
                "email" => $data->email,
                "phone" => null,
                "address" => null,
                "role" => "user",
                "profile_image" => $profile_image
            );
            http_response_code(201);
        } else {
            $response['success'] = false;
            $response['message'] = "Login gagal";
            http_response_code(500);
        }
    }
} else {
    $response['success'] = false;
    $response['message'] = "Data tidak lengkap";
    http_response_code(400);
}

echo json_encode($response);
?>
