<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

$response = array();

if (!empty($data->user_id) && !empty($data->items) && !empty($data->shipping_address)) {
    
    try {
        $db->beginTransaction();
        
        // Generate order number
        $order_number = 'ORD' . date('YmdHis') . rand(100, 999);
        
        // Calculate totals
        $total_price = 0;
        foreach ($data->items as $item) {
            $total_price += $item->price * $item->quantity;
        }
        
        $shipping_cost = isset($data->shipping_cost) ? $data->shipping_cost : 0;
        $grand_total = $total_price + $shipping_cost;
        
        // Insert order
        $query = "INSERT INTO orders (user_id, order_number, total_price, shipping_cost, grand_total, shipping_address, shipping_method, notes) 
                  VALUES (:user_id, :order_number, :total_price, :shipping_cost, :grand_total, :shipping_address, :shipping_method, :notes)";
        
        $stmt = $db->prepare($query);
        $shipping_method = isset($data->shipping_method) ? $data->shipping_method : 'Regular';
        $notes = isset($data->notes) ? $data->notes : null;
        
        $stmt->bindParam(":user_id", $data->user_id);
        $stmt->bindParam(":order_number", $order_number);
        $stmt->bindParam(":total_price", $total_price);
        $stmt->bindParam(":shipping_cost", $shipping_cost);
        $stmt->bindParam(":grand_total", $grand_total);
        $stmt->bindParam(":shipping_address", $data->shipping_address);
        $stmt->bindParam(":shipping_method", $shipping_method);
        $stmt->bindParam(":notes", $notes);
        
        $stmt->execute();
        $order_id = $db->lastInsertId();
        
        // Insert order details
        $detail_query = "INSERT INTO order_details (order_id, product_id, product_name, product_price, quantity, subtotal) 
                        VALUES (:order_id, :product_id, :product_name, :product_price, :quantity, :subtotal)";
        $detail_stmt = $db->prepare($detail_query);
        
        foreach ($data->items as $item) {
            $subtotal = $item->price * $item->quantity;
            $detail_stmt->bindParam(":order_id", $order_id);
            $detail_stmt->bindParam(":product_id", $item->product_id);
            $detail_stmt->bindParam(":product_name", $item->name);
            $detail_stmt->bindParam(":product_price", $item->price);
            $detail_stmt->bindParam(":quantity", $item->quantity);
            $detail_stmt->bindParam(":subtotal", $subtotal);
            $detail_stmt->execute();
            
            // Update product stock and total sold
            $update_query = "UPDATE products SET stock = stock - :quantity, total_sold = total_sold + :quantity WHERE id = :product_id";
            $update_stmt = $db->prepare($update_query);
            $update_stmt->bindParam(":quantity", $item->quantity);
            $update_stmt->bindParam(":product_id", $item->product_id);
            $update_stmt->execute();
        }
        
        $db->commit();
        
        $response['success'] = true;
        $response['message'] = "Order berhasil dibuat";
        $response['data'] = array(
            "order_id" => $order_id,
            "order_number" => $order_number,
            "total_price" => $total_price,
            "shipping_cost" => $shipping_cost,
            "grand_total" => $grand_total
        );
        http_response_code(201);
        
    } catch (Exception $e) {
        $db->rollBack();
        $response['success'] = false;
        $response['message'] = "Order gagal: " . $e->getMessage();
        http_response_code(500);
    }
    
} else {
    $response['success'] = false;
    $response['message'] = "Data tidak lengkap";
    http_response_code(400);
}

echo json_encode($response);
?>
