<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include_once '../../config/database.php';

$database = new Database();
$db = $database->getConnection();

$response = array();

// Check if requesting single order detail
if (isset($_GET['order_id'])) {
    $order_id = $_GET['order_id'];
    
    $query = "SELECT id, order_number, total_price, shipping_cost, grand_total, shipping_address, shipping_method, payment_proof, status, notes, created_at 
              FROM orders 
              WHERE id = :order_id";
    
    $stmt = $db->prepare($query);
    $stmt->bindParam(":order_id", $order_id);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Get order details
        $detail_query = "SELECT product_id, product_name, product_price, quantity, subtotal FROM order_details WHERE order_id = :order_id";
        $detail_stmt = $db->prepare($detail_query);
        $detail_stmt->bindParam(":order_id", $order_id);
        $detail_stmt->execute();
        
        $items = array();
        while ($detail_row = $detail_stmt->fetch(PDO::FETCH_ASSOC)) {
            array_push($items, array(
                "product_id" => $detail_row['product_id'],
                "product_name" => $detail_row['product_name'],
                "product_price" => (float)$detail_row['product_price'],
                "quantity" => (int)$detail_row['quantity'],
                "subtotal" => (float)$detail_row['subtotal']
            ));
        }
        
        $response['success'] = true;
        $response['data'] = array(
            "id" => $row['id'],
            "order_number" => $row['order_number'],
            "total_price" => (float)$row['total_price'],
            "shipping_cost" => (float)$row['shipping_cost'],
            "grand_total" => (float)$row['grand_total'],
            "shipping_address" => $row['shipping_address'],
            "shipping_method" => $row['shipping_method'],
            "payment_proof" => $row['payment_proof'],
            "status" => $row['status'],
            "notes" => $row['notes'],
            "created_at" => $row['created_at'],
            "items" => $items
        );
        http_response_code(200);
    } else {
        $response['success'] = false;
        $response['message'] = "Order tidak ditemukan";
        http_response_code(404);
    }
    
    echo json_encode($response);
    exit();
}

// Fetch all orders for user
$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : die();

$query = "SELECT id, order_number, total_price, shipping_cost, grand_total, shipping_address, shipping_method, payment_proof, status, notes, created_at 
          FROM orders 
          WHERE user_id = :user_id 
          ORDER BY created_at DESC";

$stmt = $db->prepare($query);
$stmt->bindParam(":user_id", $user_id);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    $orders_arr = array();
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        // Get order details
        $detail_query = "SELECT product_id, product_name, product_price, quantity, subtotal FROM order_details WHERE order_id = :order_id";
        $detail_stmt = $db->prepare($detail_query);
        $detail_stmt->bindParam(":order_id", $row['id']);
        $detail_stmt->execute();
        
        $items = array();
        while ($detail_row = $detail_stmt->fetch(PDO::FETCH_ASSOC)) {
            array_push($items, array(
                "product_id" => $detail_row['product_id'],
                "product_name" => $detail_row['product_name'],
                "product_price" => (float)$detail_row['product_price'],
                "quantity" => (int)$detail_row['quantity'],
                "subtotal" => (float)$detail_row['subtotal']
            ));
        }
        
        $order_item = array(
            "id" => $row['id'],
            "order_number" => $row['order_number'],
            "total_price" => (float)$row['total_price'],
            "shipping_cost" => (float)$row['shipping_cost'],
            "grand_total" => (float)$row['grand_total'],
            "shipping_address" => $row['shipping_address'],
            "shipping_method" => $row['shipping_method'],
            "payment_proof" => $row['payment_proof'],
            "status" => $row['status'],
            "notes" => $row['notes'],
            "created_at" => $row['created_at'],
            "items" => $items
        );
        
        array_push($orders_arr, $order_item);
    }
    
    $response['success'] = true;
    $response['data'] = $orders_arr;
    http_response_code(200);
} else {
    $response['success'] = true;
    $response['message'] = "Belum ada order";
    $response['data'] = array();
    http_response_code(200);
}

echo json_encode($response);
?>
