<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

$response = array();

// Validasi input
if (
    !empty($data->order_id) &&
    !empty($data->payment_method)
) {
    
    try {
        $db->beginTransaction();
        
        // Validasi payment method
        $allowed_methods = ['cod', 'transfer'];
        if (!in_array($data->payment_method, $allowed_methods)) {
            throw new Exception("Payment method tidak valid. Harus 'cod' atau 'transfer'");
        }
        
        // Cek apakah order ada
        $check_query = "SELECT id, status FROM orders WHERE id = :order_id";
        $check_stmt = $db->prepare($check_query);
        $check_stmt->bindParam(':order_id', $data->order_id);
        $check_stmt->execute();
        
        if ($check_stmt->rowCount() == 0) {
            throw new Exception("Order tidak ditemukan");
        }
        
        // Insert atau update payment
        $payment_query = "INSERT INTO payments (order_id, payment_method, status, created_at) 
                         VALUES (:order_id, :payment_method, 'pending', NOW())
                         ON DUPLICATE KEY UPDATE 
                         payment_method = :payment_method2,
                         status = 'pending',
                         updated_at = NOW()";
        
        $payment_stmt = $db->prepare($payment_query);
        $payment_stmt->bindParam(':order_id', $data->order_id);
        $payment_stmt->bindParam(':payment_method', $data->payment_method);
        $payment_stmt->bindParam(':payment_method2', $data->payment_method);
        
        if ($payment_stmt->execute()) {
            $db->commit();
            
            $response['success'] = true;
            $response['message'] = 'Payment method berhasil diset';
            $response['data'] = array(
                'order_id' => $data->order_id,
                'payment_method' => $data->payment_method,
                'payment_status' => 'pending'
            );
            http_response_code(200);
        } else {
            throw new Exception("Gagal set payment method");
        }
        
    } catch (Exception $e) {
        $db->rollBack();
        $response['success'] = false;
        $response['message'] = $e->getMessage();
        http_response_code(500);
    }
    
} else {
    $response['success'] = false;
    $response['message'] = "Data tidak lengkap. Butuh order_id dan payment_method (cod/transfer)";
    http_response_code(400);
}

echo json_encode($response);
?>
