<?php
ob_clean();
error_reporting(E_ALL);
ini_set('display_errors', 0);

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../../config/database.php';

$response = array();

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if (isset($_POST['order_id']) && isset($_FILES['payment_proof'])) {
        $order_id = $_POST['order_id'];
        $payment_method = isset($_POST['payment_method']) ? $_POST['payment_method'] : 'transfer';
        $file = $_FILES['payment_proof'];
        
        // Debug: cek file upload error
        if ($file['error'] != UPLOAD_ERR_OK) {
            $response['success'] = false;
            $response['message'] = "Upload error code: " . $file['error'];
            http_response_code(400);
            echo json_encode($response);
            exit;
        }
        
        $target_dir = "../../uploads/payments/";
        
        // Debug: cek folder ada dan bisa ditulis
        if (!file_exists($target_dir)) {
            if (!mkdir($target_dir, 0777, true)) {
                $response['success'] = false;
                $response['message'] = "Gagal membuat folder upload";
                http_response_code(500);
                echo json_encode($response);
                exit;
            }
        }
        
        if (!is_writable($target_dir)) {
            $response['success'] = false;
            $response['message'] = "Folder tidak bisa ditulis. Path: " . realpath($target_dir);
            http_response_code(500);
            echo json_encode($response);
            exit;
        }
        
        $file_extension = pathinfo($file["name"], PATHINFO_EXTENSION);
        $new_filename = "payment_" . $order_id . "_" . time() . "." . $file_extension;
        $target_file = $target_dir . $new_filename;
        
        // Debug: coba pindahkan file
        if (!move_uploaded_file($file["tmp_name"], $target_file)) {
            $response['success'] = false;
            $response['message'] = "Gagal move file ke: " . $target_file;
            http_response_code(500);
            echo json_encode($response);
            exit;
        }
        
        // File sudah berhasil diupload, sekarang update database
        $payment_query = "INSERT INTO payments (order_id, payment_proof, status, payment_method, created_at) 
                         VALUES (:order_id, :payment_proof, 'pending', :payment_method, NOW())
                         ON DUPLICATE KEY UPDATE 
                         payment_proof = :payment_proof2,
                         status = 'pending',
                         payment_method = :payment_method2,
                         updated_at = NOW()";
        $payment_stmt = $db->prepare($payment_query);
        $payment_stmt->bindParam(":order_id", $order_id);
        $payment_stmt->bindParam(":payment_proof", $new_filename);
        $payment_stmt->bindParam(":payment_method", $payment_method);
        $payment_stmt->bindParam(":payment_proof2", $new_filename);
        $payment_stmt->bindParam(":payment_method2", $payment_method);
        
        if ($payment_stmt->execute()) {
            $response['success'] = true;
            $response['message'] = "Bukti pembayaran berhasil diupload. Menunggu verifikasi admin.";
            $response['data'] = array("payment_proof" => $new_filename);
            http_response_code(200);
        } else {
            // Hapus file jika query gagal
            if (file_exists($target_file)) {
                unlink($target_file);
            }
            $response['success'] = false;
            $response['message'] = "Gagal menyimpan ke database: " . $payment_stmt->errorInfo()[2];
            http_response_code(500);
        }
    } else {
        $response['success'] = false;
        $response['message'] = "Data tidak lengkap";
        http_response_code(400);
    }
} catch (Exception $e) {
    $response['success'] = false;
    $response['message'] = "Error: " . $e->getMessage();
    http_response_code(500);
}

echo json_encode($response);
?>