<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include_once '../../config/database.php';

$database = new Database();
$db = $database->getConnection();

$response = array();

$product_id = isset($_GET['id']) ? $_GET['id'] : die();

$query = "SELECT id, name, description, price, stock, image, category, total_sold, is_active, created_at 
          FROM products 
          WHERE id = :id";

$stmt = $db->prepare($query);
$stmt->bindParam(":id", $product_id);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Base URL untuk gambar
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
    $host = $_SERVER['HTTP_HOST'];
    // Ekstrak base path sampai warung_ajib (atau nama folder root project)
    $script_name = $_SERVER['SCRIPT_NAME']; // /warung_ajib/backend_api/api/products/get_detail.php
    preg_match('/^(\/[^\/]+\/)/', $script_name, $matches);
    $base_path = $matches[1]; // /warung_ajib/
    $base_url = $protocol . "://" . $host . $base_path;
    
    // Handle image URL
    $image_url = $row['image'];
    // Jika bukan URL lengkap (http/https), tambahkan base URL
    if (!preg_match('/^https?:\/\//', $image_url)) {
        $image_url = $base_url . $image_url;
    }
    
    $response['success'] = true;
    $response['data'] = array(
        "id" => $row['id'],
        "name" => $row['name'],
        "description" => $row['description'],
        "price" => (float)$row['price'],
        "stock" => (int)$row['stock'],
        "image" => $image_url,
        "category" => $row['category'],
        "total_sold" => (int)$row['total_sold'],
        "is_active" => (bool)$row['is_active'],
        "created_at" => $row['created_at']
    );
    http_response_code(200);
} else {
    $response['success'] = false;
    $response['message'] = "Produk tidak ditemukan";
    http_response_code(404);
}

echo json_encode($response);
?>
