<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include_once '../../config/database.php';

$database = new Database();
$db = $database->getConnection();

$response = array();

$query = "SELECT setting_key, setting_value FROM settings";
$stmt = $db->prepare($query);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    $settings = array();
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
    
    $response['success'] = true;
    $response['data'] = $settings;
    http_response_code(200);
} else {
    $response['success'] = false;
    $response['message'] = "Tidak ada settings";
    http_response_code(404);
}

echo json_encode($response);
?>
