<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

$response = array();

if (!empty($data->user_id)) {
    $query = "UPDATE users SET ";
    $params = array();
    
    if (isset($data->nama_lengkap)) {
        $query .= "nama_lengkap = :nama_lengkap, ";
        $params[':nama_lengkap'] = $data->nama_lengkap;
    }
    if (isset($data->phone)) {
        $query .= "phone = :phone, ";
        $params[':phone'] = $data->phone;
    }
    if (isset($data->address)) {
        $query .= "address = :address, ";
        $params[':address'] = $data->address;
    }
    if (isset($data->new_password)) {
        $query .= "password = :password, ";
        $params[':password'] = password_hash($data->new_password, PASSWORD_DEFAULT);
    }
    
    $query = rtrim($query, ', ');
    $query .= " WHERE id = :user_id";
    $params[':user_id'] = $data->user_id;
    
    $stmt = $db->prepare($query);
    
    if ($stmt->execute($params)) {
        $response['success'] = true;
        $response['message'] = "Profile berhasil diupdate";
        http_response_code(200);
    } else {
        $response['success'] = false;
        $response['message'] = "Gagal update profile";
        http_response_code(500);
    }
} else {
    $response['success'] = false;
    $response['message'] = "User ID tidak ditemukan";
    http_response_code(400);
}

echo json_encode($response);
?>
