# Data Kota/Kabupaten Indonesia (Dengan Koordinat)

API `api/locations/search_cities.php` membaca file JSON di folder ini: `indonesia_cities_with_coords.json`.

## Isi Data
Setiap item harus memiliki field:
- `name`  : Nama kota/kabupaten (contoh: "Kota Bandung", "Kabupaten Kudus")
- `province` : Nama provinsi (contoh: "Jawa Barat")
- `type`  : `Kota` atau `Kabupaten`
- `lat`   : Latitude (float)
- `lng`   : Longitude (float)

## Cara Mengisi Data Penuh (CSV → JSON)
1. Siapkan file CSV berisi seluruh kab/kota Indonesia dengan kolom: `name,province,type,lat,lng`.
   - Lihat contoh: `indonesia_cities_with_coords.sample.csv`.
2. Letakkan CSV Anda sebagai `backend_api/database/indonesia_cities_with_coords.csv`.
3. Jalankan importer (butuh PHP CLI, XAMPP sudah menyertakan `C:\xampp\php\php.exe`):
   ```powershell
   cd "D:\Mobile App UMKM"
   C:\xampp\php\php.exe backend_api\tools\import_cities.php backend_api\database\indonesia_cities_with_coords.csv
   ```
4. Berkas `indonesia_cities_with_coords.json` akan dibuat/ditimpa.
5. Buka API dari browser/HP untuk uji:  
   `http://<IP_PC>/warung_ajib/backend_api/api/locations/search_cities.php?q=bandung`

## Catatan
- Importer akan menormalkan `type` otomatis ("Kab" → `Kabupaten`, dll), menghapus duplikat, dan mengabaikan koordinat di luar rentang Indonesia.
- Jika Anda memperbarui CSV, cukup jalankan ulang importer.

## Alternatif: Bangun dari GeoJSON Lokal (Offline)
Jika komputer Anda tidak bisa mengunduh dataset secara otomatis:
1. Download file GeoJSON kabupaten/kota (contoh sumber komunitas GitHub) dari komputer/HP lain, lalu salin ke:
   - `backend_api/database/kabupaten_kota.geojson`
2. Jalankan builder lokal untuk membuat CSV dan JSON (koordinat dihitung dari centroid poligon):
   ```powershell
   cd "D:\Mobile App UMKM"
   C:\xampp\php\php.exe backend_api\tools\local_build_cities.php backend_api\database\kabupaten_kota.geojson
   ```
3. File `indonesia_cities_with_coords.json` akan terisi penuh.
4. Uji API: `http://<IP_PC>/warung_ajib/backend_api/api/locations/search_cities.php?q=bandung`

Catatan: Nama akan dinormalisasi menjadi "Kota ..." / "Kabupaten ..." agar konsisten.
