-- =========================================
-- RESET ALL DATA - WARUNG AJIB
-- =========================================
-- KEMBALIKAN DATABASE KE KONDISI BAWAAN/FRESH INSTALL
-- =========================================
-- Script ini akan menghapus SEMUA data dan kembali ke data DEFAULT saja:
-- - Hapus SEMUA user → Sisakan 1 admin default
-- - Hapus SEMUA produk → Kembalikan 6 produk bawaan
-- - Hapus SEMUA orders/payments
-- - Kembalikan settings default
-- =========================================

USE warung_ajib;

SET FOREIGN_KEY_CHECKS = 0;

-- =========================================
-- 1. HAPUS SEMUA DATA TRANSAKSI
-- =========================================
TRUNCATE TABLE order_details;
TRUNCATE TABLE payments;
TRUNCATE TABLE orders;

-- =========================================
-- 2. HAPUS SEMUA USER
-- =========================================
TRUNCATE TABLE users;

-- =========================================
-- 3. HAPUS SEMUA PRODUK
-- =========================================
TRUNCATE TABLE products;

-- =========================================
-- 4. HAPUS SEMUA SETTINGS
-- =========================================
TRUNCATE TABLE settings;

-- =========================================
-- 5. RESET AUTO INCREMENT
-- =========================================
ALTER TABLE orders AUTO_INCREMENT = 1;
ALTER TABLE order_details AUTO_INCREMENT = 1;
ALTER TABLE payments AUTO_INCREMENT = 1;
ALTER TABLE products AUTO_INCREMENT = 1;
ALTER TABLE users AUTO_INCREMENT = 1;
ALTER TABLE settings AUTO_INCREMENT = 1;

-- =========================================
-- 6. INSERT DATA BAWAAN/DEFAULT
-- =========================================

-- Insert default admin user (PASSWORD: password)
INSERT INTO users (nama_lengkap, username, email, password, role) 
VALUES ('Admin Warung Ajib', 'admin', 'admin@warungajib.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin');

-- Insert sample products (DATA BAWAAN)
INSERT INTO products (name, description, price, stock, category, image, total_sold) VALUES
('Es Teh Ajib', 'Es teh segar dengan rasa yang nikmat, cocok untuk menemani hari Anda', 5000, 100, 'Minuman', 'es_teh.jpg', 0),
('Lumpia Semarang', 'Lumpia Semarang isi rebung dan ayam yang gurih', 15000, 50, 'Makanan', 'lumpia.jpg', 0),
('Jaipuran Spesial', 'Jajanan tradisional khas Demak dengan rasa manis', 10000, 75, 'Makanan', 'jaipuran.jpg', 0),
('Kopi Susu Ajib', 'Kopi susu dengan campuran gula aren yang manis', 12000, 80, 'Minuman', 'kopi_susu.jpg', 0),
('Bakso Mercon', 'Bakso dengan sambal pedas yang menggigit', 18000, 40, 'Makanan', 'bakso.jpg', 0),
('Jus Alpukat', 'Jus alpukat segar tanpa tambahan gula', 15000, 60, 'Minuman', 'jus_alpukat.jpg', 0);

-- Insert default settings
INSERT INTO settings (setting_key, setting_value) VALUES
('call_center', '081234567890'),
('sms_center', '081234567890'),
('whatsapp', '081234567890'),
('email', 'contact@warungajib.com'),
('address', 'Bandungrejo, Mranggen, Demak, Jawa Tengah'),
('maps_latitude', '-6.9774'),
('maps_longitude', '110.4204'),
('shipping_cost_per_km', '2000'),
('app_name', 'Warung Ajib'),
('app_tagline', 'Belanja Mudah, Hasil Nikmat');

SET FOREIGN_KEY_CHECKS = 1;

-- =========================================
-- SELESAI - DATABASE BERSIH SEPERTI BAWAAN
-- =========================================
SELECT 'SUCCESS: Database reset to DEFAULT/BAWAAN!' as status;
SELECT 
    (SELECT COUNT(*) FROM users) as total_users,
    (SELECT COUNT(*) FROM products) as total_products,
    (SELECT COUNT(*) FROM orders) as total_orders,
    (SELECT COUNT(*) FROM settings) as total_settings;
