-- =========================================
-- RESET ALL ORDER DATA - WARUNG AJIB
-- =========================================
-- Script untuk menghapus semua data pesanan
-- dan mengembalikan database seperti semula
-- =========================================

USE warung_ajib;

-- 1. Hapus semua data pesanan (order details akan terhapus otomatis karena CASCADE)
SET FOREIGN_KEY_CHECKS = 0;

TRUNCATE TABLE order_details;
TRUNCATE TABLE payments;
TRUNCATE TABLE orders;

-- 2. Reset auto increment ke 1
ALTER TABLE orders AUTO_INCREMENT = 1;
ALTER TABLE order_details AUTO_INCREMENT = 1;
ALTER TABLE payments AUTO_INCREMENT = 1;

-- 3. Reset total_sold di products kembali ke 0
UPDATE products SET total_sold = 0;

SET FOREIGN_KEY_CHECKS = 1;

-- Selesai! Semua data pesanan sudah dihapus dan database kembali seperti semula
SELECT 'SUCCESS: All order data has been deleted!' as status;
