-- =========================================
-- RESET TRANSACTIONS ONLY - WARUNG AJIB
-- =========================================
-- Script untuk menghapus data transaksi saja
-- Produk dan user tetap ada
-- =========================================

USE warung_ajib;

SET FOREIGN_KEY_CHECKS = 0;

-- =========================================
-- 1. HAPUS SEMUA DATA PESANAN
-- =========================================
TRUNCATE TABLE order_details;
TRUNCATE TABLE payments;
TRUNCATE TABLE orders;

-- =========================================
-- 2. RESET AUTO INCREMENT
-- =========================================
ALTER TABLE orders AUTO_INCREMENT = 1;
ALTER TABLE order_details AUTO_INCREMENT = 1;
ALTER TABLE payments AUTO_INCREMENT = 1;

-- =========================================
-- 3. RESET TOTAL_SOLD DI PRODUCTS
-- =========================================
UPDATE products SET total_sold = 0;

-- =========================================
-- 4. HAPUS USER TEST (OPSIONAL)
-- =========================================
-- Hapus user yang dibuat saat testing
-- Kecuali admin dan user dengan role penting
DELETE FROM users 
WHERE role = 'user' 
AND username LIKE 'test%';

SET FOREIGN_KEY_CHECKS = 1;

-- =========================================
-- SELESAI
-- =========================================
SELECT 'SUCCESS: All transaction data has been deleted!' as status;
SELECT 
    (SELECT COUNT(*) FROM orders) as total_orders,
    (SELECT COUNT(*) FROM users) as total_users,
    (SELECT COUNT(*) FROM products) as total_products;
