<?php
// Isi koordinat untuk seluruh kab/kota berdasarkan daftar nama (dari SQL) menggunakan Nominatim.
// Pemakaian:
//   php backend_api/tools/fill_coords_from_names.php [maxCount]
//   - maxCount opsional: batasi jumlah kota yang diisi pada eksekusi ini.

function stderr($m){ fwrite(STDERR, $m.PHP_EOL); }

$namesPath = __DIR__.'/../database/indonesia_cities_names.json';
$coordsPath = __DIR__.'/../database/indonesia_cities_with_coords.json';

if (!file_exists($namesPath)) { stderr('File nama tidak ditemukan: '.$namesPath); exit(1); }
$names = json_decode(file_get_contents($namesPath), true);
if (!is_array($names)) { stderr('Format nama tidak valid.'); exit(1); }

$coords = [];
if (file_exists($coordsPath)){
  $coords = json_decode(file_get_contents($coordsPath), true);
  if (!is_array($coords)) $coords = [];
}

$have = [];
foreach ($coords as $r){ $k = strtolower(($r['name']??'').'|'.($r['province']??'')); $have[$k]=true; }

$max = isset($argv[1]) ? intval($argv[1]) : 0; // 0 = tak terbatas
$done = 0;
$updated = 0;

foreach ($names as $row){
  $name = trim($row['name'] ?? '');
  $prov = trim($row['province'] ?? '');
  if ($name==='' || $prov==='') continue;
  $key = strtolower($name.'|'.$prov);
  if (isset($have[$key])) { $done++; continue; }

  // Coba beberapa variasi query agar hasil tepat
  $queries = [
    $name.' '.$prov.' Indonesia',
    'Kota '.$name.' '.$prov.' Indonesia',
    'Kabupaten '.$name.' '.$prov.' Indonesia',
  ];

  $latlng = null;
  foreach ($queries as $q){
    $latlng = nominatim($q);
    if ($latlng) break;
    usleep(500000); // 0.5 detik jeda antar percobaan
  }

  if ($latlng){
    $coords[] = [
      'name' => $name,
      'province' => $prov,
      'type' => guess_type($name),
      'lat' => $latlng[0],
      'lng' => $latlng[1],
    ];
    $have[$key] = true;
    $updated++;
    echo "+ $name, $prov => {$latlng[0]}, {$latlng[1]}".PHP_EOL;
  } else {
    echo "- $name, $prov => GAGAL".PHP_EOL;
  }

  // Simpan berkala untuk menghindari kehilangan progres
  if ($updated>0 && $updated % 10 === 0){ save_coords($coordsPath, $coords); }

  // Rate limit agar tidak diblokir
  sleep(1);
  if ($max>0 && ($updated + $done) >= $max) break;
}

save_coords($coordsPath, $coords);
echo "Selesai. Diupdate: $updated, Sudah ada: $done, Total kini: ".count($coords).PHP_EOL;
exit(0);

function nominatim($query){
  $url = 'https://nominatim.openstreetmap.org/search?format=json&limit=1&q='.rawurlencode($query);
  $ctx = stream_context_create(['http'=>['timeout'=>15,'header'=>"User-Agent: WarungAjib/1.0\r\nAccept: application/json\r\n"]]);
  $raw = @file_get_contents($url,false,$ctx); if(!$raw) return null;
  $arr = json_decode($raw,true); if(!is_array($arr)||empty($arr)) return null;
  $lat = isset($arr[0]['lat']) ? floatval($arr[0]['lat']) : null;
  $lon = isset($arr[0]['lon']) ? floatval($arr[0]['lon']) : null;
  if ($lat===null || $lon===null) return null;
  if ($lat < -11 || $lat > 6) return null;
  if ($lon < 95 || $lon > 142) return null;
  return [$lat,$lon];
}

function guess_type($name){
  $l = mb_strtolower($name);
  if (strpos($l,'kabupaten')===0 || strpos($l,'kab ')===0 || strpos($l,'kab.')===0) return 'Kabupaten';
  if (strpos($l,'kota')===0) return 'Kota';
  return '';
}

function save_coords($path, $data){
  // Urutkan untuk stabilitas
  usort($data, function($a,$b){ $c = strcmp($a['province'],$b['province']); if($c!==0) return $c; return strcmp($a['name'],$b['name']); });
  file_put_contents($path, json_encode($data, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES));
}
?>
