<?php
session_start();

if (!isset($_SESSION['admin_id'])) {
    header('Location: index.php');
    exit;
}

require_once '../backend_api/config/database.php';

$database = new Database();
$db = $database->getConnection();

// Get statistics
$stats = [];

// Total Products
$query = "SELECT COUNT(*) as total FROM products WHERE is_active = 1";
$stmt = $db->prepare($query);
$stmt->execute();
$stats['total_products'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// Total Orders
$query = "SELECT COUNT(*) as total FROM orders";
$stmt = $db->prepare($query);
$stmt->execute();
$stats['total_orders'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// Total Revenue
$query = "SELECT SUM(grand_total) as total FROM orders WHERE status IN ('paid', 'processing', 'shipped', 'delivered')";
$stmt = $db->prepare($query);
$stmt->execute();
$stats['total_revenue'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'] ?? 0;

// Total Customers
$query = "SELECT COUNT(*) as total FROM users WHERE role = 'user'";
$stmt = $db->prepare($query);
$stmt->execute();
$stats['total_customers'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

// Orders by status
$status_query = "SELECT 
    SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending,
    SUM(CASE WHEN status = 'processing' THEN 1 ELSE 0 END) as processing,
    SUM(CASE WHEN status = 'shipped' THEN 1 ELSE 0 END) as shipped,
    SUM(CASE WHEN status = 'delivered' THEN 1 ELSE 0 END) as delivered,
    SUM(CASE WHEN status = 'cancelled' THEN 1 ELSE 0 END) as cancelled
    FROM orders";
$status_stmt = $db->prepare($status_query);
$status_stmt->execute();
$status_counts = $status_stmt->fetch(PDO::FETCH_ASSOC);

// Recent Orders
$query = "SELECT o.*, u.nama_lengkap as customer_name FROM orders o 
          LEFT JOIN users u ON o.user_id = u.id 
          ORDER BY o.created_at DESC LIMIT 10";
$stmt = $db->prepare($query);
$stmt->execute();
$recent_orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

include 'includes/header.php';
?>

<!-- Page Heading -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-1 fw-bold text-dark">Dashboard</h1>
        <p class="text-muted mb-0">
            <i class="bi bi-calendar3 me-1"></i>
            <?php echo date('l, d F Y'); ?>
        </p>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row g-3 mb-4">
    <div class="col-12 col-sm-6 col-xl-3">
        <div class="card card-stat primary h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase mb-1 fw-semibold" style="font-size: 0.75rem;">Total Produk</p>
                        <h3 class="fw-bold mb-0"><?php echo number_format($stats['total_products']); ?></h3>
                    </div>
                    <div class="rounded-circle p-3" style="background-color: rgba(79, 70, 229, 0.1);">
                        <i class="bi bi-box-seam fs-4 text-primary"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-12 col-sm-6 col-xl-3">
        <div class="card card-stat success h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase mb-1 fw-semibold" style="font-size: 0.75rem;">Total Pesanan</p>
                        <h3 class="fw-bold mb-0"><?php echo number_format($stats['total_orders']); ?></h3>
                    </div>
                    <div class="rounded-circle p-3" style="background-color: rgba(16, 185, 129, 0.1);">
                        <i class="bi bi-cart-check fs-4 text-success"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-12 col-sm-6 col-xl-3">
        <div class="card card-stat warning h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase mb-1 fw-semibold" style="font-size: 0.75rem;">Total Pendapatan</p>
                        <h3 class="fw-bold mb-0" style="font-size: 1.5rem;">Rp <?php echo number_format($stats['total_revenue'], 0, ',', '.'); ?></h3>
                    </div>
                    <div class="rounded-circle p-3" style="background-color: rgba(245, 158, 11, 0.1);">
                        <i class="bi bi-currency-dollar fs-4 text-warning"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-12 col-sm-6 col-xl-3">
        <div class="card card-stat info h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase mb-1 fw-semibold" style="font-size: 0.75rem;">Total Pelanggan</p>
                        <h3 class="fw-bold mb-0"><?php echo number_format($stats['total_customers']); ?></h3>
                    </div>
                    <div class="rounded-circle p-3" style="background-color: rgba(14, 165, 233, 0.1);">
                        <i class="bi bi-people fs-4 text-info"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Order Status Cards -->
<div class="row g-3 mb-4">
    <div class="col-6 col-md-4 col-lg">
        <div class="card card-stat primary h-100">
            <div class="card-body text-center py-3">
                <i class="bi bi-clock-history fs-3 mb-2 text-primary"></i>
                <p class="text-muted mb-1 fw-semibold" style="font-size: 0.75rem;">PENDING</p>
                <h4 class="fw-bold mb-0"><?php echo (int)($status_counts['pending'] ?? 0); ?></h4>
            </div>
        </div>
    </div>
    <div class="col-6 col-md-4 col-lg">
        <div class="card card-stat info h-100">
            <div class="card-body text-center py-3">
                <i class="bi bi-hourglass-split fs-3 mb-2 text-info"></i>
                <p class="text-muted mb-1 fw-semibold" style="font-size: 0.75rem;">DIPROSES</p>
                <h4 class="fw-bold mb-0"><?php echo (int)($status_counts['processing'] ?? 0); ?></h4>
            </div>
        </div>
    </div>
    <div class="col-6 col-md-4 col-lg">
        <div class="card card-stat warning h-100">
            <div class="card-body text-center py-3">
                <i class="bi bi-truck fs-3 mb-2 text-warning"></i>
                <p class="text-muted mb-1 fw-semibold" style="font-size: 0.75rem;">DIKIRIM</p>
                <h4 class="fw-bold mb-0"><?php echo (int)($status_counts['shipped'] ?? 0); ?></h4>
            </div>
        </div>
    </div>
    <div class="col-6 col-md-4 col-lg">
        <div class="card card-stat success h-100">
            <div class="card-body text-center py-3">
                <i class="bi bi-check-circle fs-3 mb-2 text-success"></i>
                <p class="text-muted mb-1 fw-semibold" style="font-size: 0.75rem;">SELESAI</p>
                <h4 class="fw-bold mb-0"><?php echo (int)($status_counts['delivered'] ?? 0); ?></h4>
            </div>
        </div>
    </div>
    <div class="col-6 col-md-4 col-lg">
        <div class="card card-stat danger h-100">
            <div class="card-body text-center py-3">
                <i class="bi bi-x-circle fs-3 mb-2 text-danger"></i>
                <p class="text-muted mb-1 fw-semibold" style="font-size: 0.75rem;">DIBATALKAN</p>
                <h4 class="fw-bold mb-0"><?php echo (int)($status_counts['cancelled'] ?? 0); ?></h4>
            </div>
        </div>
    </div>
</div>

<!-- Recent Orders Table -->
<div class="card shadow-sm">
    <div class="card-header bg-white py-3">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0 fw-bold">
                <i class="bi bi-clock-history me-2"></i>
                Pesanan Terbaru
            </h5>
            <a href="orders.php" class="btn btn-sm btn-primary">
                <i class="bi bi-arrow-right-circle me-1"></i>
                Lihat Semua
            </a>
        </div>
    </div>
    <div class="card-body p-4">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead>
                    <tr>
                        <th class="ps-4">No. Pesanan</th>
                        <th>Pelanggan</th>
                        <th>Total</th>
                        <th>Status</th>
                        <th>Tanggal</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($recent_orders)): ?>
                        <tr>
                            <td colspan="6" class="text-center py-5">
                                <i class="bi bi-inbox fs-1 text-muted d-block mb-3"></i>
                                <p class="text-muted mb-0">Belum ada pesanan</p>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($recent_orders as $order): ?>
                            <tr>
                                <td class="ps-4">
                                    <span class="fw-semibold"><?php echo $order['order_number']; ?></span>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="rounded-circle bg-light p-2 me-2">
                                            <i class="bi bi-person"></i>
                                        </div>
                                        <?php echo htmlspecialchars($order['customer_name']); ?>
                                    </div>
                                </td>
                                <td>
                                    <span class="fw-semibold">Rp <?php echo number_format($order['grand_total'], 0, ',', '.'); ?></span>
                                </td>
                                <td>
                                    <span class="badge status-<?php echo $order['status']; ?>">
                                        <?php 
                                        $status_text = [
                                            'pending' => 'Pending',
                                            'processing' => 'Diproses',
                                            'shipped' => 'Dikirim',
                                            'delivered' => 'Selesai',
                                            'cancelled' => 'Dibatalkan'
                                        ];
                                        echo $status_text[$order['status']] ?? $order['status'];
                                        ?>
                                    </span>
                                </td>
                                <td>
                                    <small class="text-muted">
                                        <?php echo date('d M Y, H:i', strtotime($order['created_at'])); ?>
                                    </small>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>