</div>
    </main>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
    
    <script>
        console.log("Footer script is running.");
        $(document).ready(function() {
            // Initialize DataTables - hanya untuk table yang tidak punya ID atau belum diinisialize
            setTimeout(function() {
                $('.table:not([id])').each(function() {
                    const $table = $(this);
                    
                    // Skip jika table punya class no-datatable
                    if ($table.hasClass('no-datatable')) {
                        return;
                    }
                    
                    // Inisialisasi hanya untuk table tanpa ID
                    try {
                        if (!$.fn.DataTable.isDataTable($table)) {
                            $table.DataTable({
                                "language": {
                                    "url": "//cdn.datatables.net/plug-ins/1.13.8/i18n/id.json"
                                },
                                "pageLength": 10,
                                "responsive": true,
                                "order": [[4, "desc"]]
                            });
                        }
                    } catch (e) {
                        console.warn('DataTable initialization error:', e);
                    }
                });
            }, 200); // Delay 200ms untuk tunggu page-specific scripts

            // Mobile Sidebar Toggle
            const sidebar = $('#sidebar');
            const sidebarOverlay = $('#sidebarOverlay');
            const mobileToggle = $('#mobileToggle');

            // Toggle sidebar
            mobileToggle.on('click', function() {
                sidebar.toggleClass('show');
                sidebarOverlay.toggleClass('show');
            });

            // Close sidebar when overlay clicked
            sidebarOverlay.on('click', function() {
                sidebar.removeClass('show');
                sidebarOverlay.removeClass('show');
            });

            // Close sidebar when link clicked on mobile
            if ($(window).width() <= 991) {
                $('.nav-link').on('click', function() {
                    sidebar.removeClass('show');
                    sidebarOverlay.removeClass('show');
                });
            }

            // Active nav link
            const currentPath = window.location.pathname.split('/').pop();
            $('.nav-link').each(function() {
                const linkPath = $(this).attr('href');
                if (linkPath === currentPath) {
                    $(this).addClass('active');
                } else {
                    $(this).removeClass('active');
                }
            });

            // Smooth scroll to top
            $(window).scroll(function() {
                if ($(this).scrollTop() > 100) {
                    $('#scrollToTop').fadeIn();
                } else {
                    $('#scrollToTop').fadeOut();
                }
            });

            // Card hover animation
            $('.card').hover(
                function() {
                    $(this).addClass('shadow-lg');
                },
                function() {
                    $(this).removeClass('shadow-lg');
                }
            );

            // Toast notifications (if needed)
            const toastElList = [].slice.call(document.querySelectorAll('.toast'));
            const toastList = toastElList.map(function(toastEl) {
                return new bootstrap.Toast(toastEl);
            });

            // Auto dismiss alerts
            $('.alert').each(function() {
                const alert = $(this);
                setTimeout(function() {
                    alert.fadeOut('slow');
                }, 5000);
            });

            // Confirmation dialogs
            $('[data-confirm]').on('click', function(e) {
                const message = $(this).data('confirm') || 'Apakah Anda yakin?';
                if (!confirm(message)) {
                    e.preventDefault();
                    return false;
                }
            });

            // Number formatting
            $('.format-number').each(function() {
                const num = parseInt($(this).text());
                $(this).text(num.toLocaleString('id-ID'));
            });

            // Currency formatting
            $('.format-currency').each(function() {
                const num = parseInt($(this).text());
                $(this).text('Rp ' + num.toLocaleString('id-ID'));
            });

            // Tooltip initialization
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            const tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });

            // Popover initialization
            const popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'));
            const popoverList = popoverTriggerList.map(function(popoverTriggerEl) {
                return new bootstrap.Popover(popoverTriggerEl);
            });

            // Handle window resize
            let resizeTimer;
            $(window).on('resize', function() {
                clearTimeout(resizeTimer);
                resizeTimer = setTimeout(function() {
                    // Close sidebar on desktop view
                    if ($(window).width() > 991) {
                        sidebar.removeClass('show');
                        sidebarOverlay.removeClass('show');
                    }
                }, 250);
            });

            // Prevent double submission
            $('form').on('submit', function() {
                $(this).find('button[type="submit"]').prop('disabled', true);
            });

            // Auto-hide success messages
            setTimeout(function() {
                $('.alert-success').fadeOut('slow');
            }, 3000);

            // Loading state for buttons
            $('.btn-loading').on('click', function() {
                const btn = $(this);
                const originalText = btn.html();
                btn.prop('disabled', true);
                btn.html('<span class="spinner-border spinner-border-sm me-2" role="status"></span>Loading...');
                
                // Simulate loading (remove in production, handle via actual form submission)
                setTimeout(function() {
                    btn.prop('disabled', false);
                    btn.html(originalText);
                }, 2000);
            });
        });

        // Helper function for AJAX error handling
        function handleAjaxError(xhr, status, error) {
            console.error('AJAX Error:', status, error);
            alert('Terjadi kesalahan. Silakan coba lagi.');
        }

        // Helper function for showing toast
        function showToast(message, type = 'info') {
            const toastHtml = `
                <div class="toast align-items-center text-white bg-${type} border-0" role="alert" aria-live="assertive" aria-atomic="true">
                    <div class="d-flex">
                        <div class="toast-body">${message}</div>
                        <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
                    </div>
                </div>
            `;
            
            const toastContainer = $('#toastContainer');
            if (!toastContainer.length) {
                $('body').append('<div id="toastContainer" class="toast-container position-fixed top-0 end-0 p-3"></div>');
            }
            
            $('#toastContainer').append(toastHtml);
            const toastElement = $('#toastContainer .toast').last()[0];
            const toast = new bootstrap.Toast(toastElement);
            toast.show();
            
            // Remove toast after hidden
            $(toastElement).on('hidden.bs.toast', function() {
                $(this).remove();
            });
        }
    </script>
</body>
</html>