<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Warung Ajib Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="assets/css/style.css?v=<?php echo time(); ?>">
</head>
<body class="bg-gradient-primary">
    <div class="container">
        <div class="row justify-content-center align-items-center min-vh-100">
            <div class="col-xl-10 col-lg-12 col-md-9">
                <div class="card shadow-lg border-0">
                    <div class="card-body p-0">
                        <div class="row">
                            <div class="col-lg-6 d-none d-lg-block bg-login-image">
                                <div class="p-5 h-100 d-flex flex-column justify-content-center text-white text-center">
                                    <img src="assets/images/logo.png" alt="Warung Ajib" style="width: 200px; height: 200px; object-fit: contain; margin: 0 auto 24px;">
                                    <h1 class="display-4 fw-bold mb-3">Warung Ajib</h1>
                                    <p class="lead">Sistem Manajemen Admin untuk mengelola produk, pesanan, dan pelanggan.</p>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="p-5">
                                    <div class="text-center">
                                        <h1 class="h3 text-gray-900 mb-4 fw-bold">Selamat Datang Admin!</h1>
                                    </div>
                                    
                                    <?php if(isset($_GET['error'])): ?>
                                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                            <i class="bi bi-exclamation-triangle-fill me-2"></i>
                                            <?php echo htmlspecialchars($_GET['error']); ?>
                                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <form action="process/login_process.php" method="POST" class="user">
                                        <div class="mb-3">
                                            <label class="form-label">Username atau Email</label>
                                            <div class="input-group">
                                                <span class="input-group-text"><i class="bi bi-person"></i></span>
                                                <input type="text" class="form-control form-control-lg" name="username" required autofocus>
                                            </div>
                                        </div>
                                        <div class="mb-4">
                                            <label class="form-label">Password</label>
                                            <div class="input-group">
                                                <span class="input-group-text"><i class="bi bi-lock"></i></span>
                                                <input type="password" class="form-control form-control-lg" name="password" required>
                                            </div>
                                        </div>
                                        <button type="submit" class="btn btn-primary btn-lg w-100">
                                            <i class="bi bi-box-arrow-in-right me-2"></i>Login
                                        </button>
                                    </form>
                                    <hr class="my-4">
                                    <div class="text-center">
                                        <small class="text-muted">© 2026 Warung Ajib. All rights reserved.</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
