<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: index.php');
    exit;
}

include 'includes/header.php';

$order_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
?>

<div class="container-fluid py-4">
    <div class="row mb-3">
        <div class="col-md-12 d-flex align-items-center justify-content-between">
            <h2 class="fw-bold gradient-text">
                <i class="fas fa-file-invoice me-2"></i>Detail Pesanan
            </h2>
            <div>
                <a href="orders.php" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left"></i> Kembali ke Pesanan
                </a>
            </div>
        </div>
    </div>

    <div id="orderDetailContainer">
        <?php
        // Render detail using the same process file
        $_GET['id'] = $order_id;
        include 'process/get_order_detail.php';
        ?>
    </div>
</div>

<script>
function loadOrderDetail(orderId) {
    fetch('process/get_order_detail.php?id=' + encodeURIComponent(orderId))
        .then(function(response){ return response.text(); })
        .then(function(html){
            document.getElementById('orderDetailContainer').innerHTML = html;
        })
        .catch(function(){
            document.getElementById('orderDetailContainer').innerHTML = '<div class="alert alert-danger">Gagal memuat detail pesanan</div>';
        });
}
</script>

<?php include 'includes/footer.php'; ?>
