<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    exit('Unauthorized');
}

require_once '../../backend_api/config/database.php';
$database = new Database();
$db = $database->getConnection();

$customer_id = isset($_GET['id']) ? $_GET['id'] : 0;

$query = "SELECT * FROM users WHERE id = :customer_id AND role = 'user'";
$stmt = $db->prepare($query);
$stmt->bindParam(':customer_id', $customer_id);
$stmt->execute();
$customer = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$customer) {
    echo '<div class="alert alert-danger">Pelanggan tidak ditemukan</div>';
    exit;
}

// Get orders history
$orders_query = "SELECT * FROM orders WHERE user_id = :customer_id ORDER BY created_at DESC LIMIT 10";
$orders_stmt = $db->prepare($orders_query);
$orders_stmt->bindParam(':customer_id', $customer_id);
$orders_stmt->execute();
$orders = $orders_stmt->fetchAll(PDO::FETCH_ASSOC);

// Get statistics
$stats_query = "SELECT 
    COUNT(*) as total_orders,
    SUM(grand_total) as total_spent,
    AVG(grand_total) as avg_order
    FROM orders WHERE user_id = :customer_id AND status != 'cancelled'";
$stats_stmt = $db->prepare($stats_query);
$stats_stmt->bindParam(':customer_id', $customer_id);
$stats_stmt->execute();
$stats = $stats_stmt->fetch(PDO::FETCH_ASSOC);
?>

<div class="row mb-3">
    <div class="col-md-12">
        <div class="d-flex align-items-center">
            <div class="avatar-circle bg-primary text-white me-3" style="width: 60px; height: 60px; font-size: 24px;">
                <?= strtoupper(substr($customer['nama_lengkap'], 0, 2)) ?>
            </div>
            <div>
                <h5 class="mb-0"><?= htmlspecialchars($customer['nama_lengkap']) ?></h5>
                <p class="text-muted mb-0">@<?= htmlspecialchars($customer['username']) ?></p>
            </div>
        </div>
    </div>
</div>

<div class="row mb-3">
    <div class="col-md-4">
        <div class="card border-0 bg-light">
            <div class="card-body text-center">
                <h4 class="fw-bold text-primary"><?= $stats['total_orders'] ?></h4>
                <p class="text-muted mb-0">Total Pesanan</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card border-0 bg-light">
            <div class="card-body text-center">
                <h4 class="fw-bold text-success">Rp <?= number_format($stats['total_spent'] ?? 0, 0, ',', '.') ?></h4>
                <p class="text-muted mb-0">Total Belanja</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card border-0 bg-light">
            <div class="card-body text-center">
                <h4 class="fw-bold text-info">Rp <?= number_format($stats['avg_order'] ?? 0, 0, ',', '.') ?></h4>
                <p class="text-muted mb-0">Rata-rata Pesanan</p>
            </div>
        </div>
    </div>
</div>

<hr>

<h6 class="fw-bold">Informasi Kontak</h6>
<table class="table table-sm">
    <tr>
        <td width="120">Email:</td>
        <td><?= htmlspecialchars($customer['email']) ?></td>
    </tr>
    <tr>
        <td>No. HP:</td>
        <td><?= htmlspecialchars($customer['phone'] ?? '-') ?></td>
    </tr>
    <tr>
        <td>Alamat:</td>
        <td><?= htmlspecialchars($customer['address'] ?? 'Belum diisi') ?></td>
    </tr>
    <tr>
        <td>Bergabung:</td>
        <td><?= date('d F Y', strtotime($customer['created_at'])) ?></td>
    </tr>
</table>

<hr>

<h6 class="fw-bold">Riwayat Pesanan (10 Terakhir)</h6>
<div class="table-responsive">
    <table class="table table-sm table-hover">
        <thead class="table-light">
            <tr>
                <th>No. Order</th>
                <th>Tanggal</th>
                <th>Total</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($orders as $order): ?>
            <tr>
                <td><strong>#<?= $order['order_number'] ?></strong></td>
                <td><?= date('d/m/Y', strtotime($order['created_at'])) ?></td>
                <td>Rp <?= number_format($order['grand_total'], 0, ',', '.') ?></td>
                <td>
                    <?php
                    $status_badges = [
                        'pending' => 'warning',
                        'processing' => 'info',
                        'shipped' => 'primary',
                        'delivered' => 'success',
                        'cancelled' => 'danger'
                    ];
                    $badge = $status_badges[$order['status']] ?? 'secondary';
                    ?>
                    <span class="badge bg-<?= $badge ?>"><?= $order['status'] ?></span>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<style>
.avatar-circle {
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
}
</style>
