<?php
session_start();

require_once '../../backend_api/config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (empty($username) || empty($password)) {
        header('Location: ../index.php?error=Username dan password harus diisi');
        exit;
    }
    
    $database = new Database();
    $db = $database->getConnection();
    
    $query = "SELECT id, nama_lengkap, username, email, password, role FROM users WHERE (username = :username OR email = :username) AND role = 'admin'";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':username', $username);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (password_verify($password, $user['password'])) {
            $_SESSION['admin_id'] = $user['id'];
            $_SESSION['admin_name'] = $user['nama_lengkap'];
            $_SESSION['admin_email'] = $user['email'];
            $_SESSION['admin_role'] = $user['role'];
            
            header('Location: ../dashboard.php');
            exit;
        } else {
            header('Location: ../index.php?error=Password salah');
            exit;
        }
    } else {
        header('Location: ../index.php?error=Admin tidak ditemukan');
        exit;
    }
} else {
    header('Location: ../index.php');
    exit;
}
?>
