<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 0);
header('Content-Type: application/json');

if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

require_once '../../backend_api/config/database.php';
$db = (new Database())->getConnection();

$action = $_POST['action'] ?? '';

try {

    /* ===================== ADD ===================== */
    if ($action === 'add') {

        $name        = trim($_POST['name'] ?? '');
        $description = trim($_POST['description'] ?? '');
        $price       = isset($_POST['price']) ? floatval($_POST['price']) : 0;
        $stock       = isset($_POST['stock']) ? intval($_POST['stock']) : 0;
        $category    = trim($_POST['category'] ?? '');

        if ($name === '' || $description === '' || $category === '') {
            echo json_encode(['success' => false, 'message' => 'Nama, deskripsi, dan kategori harus diisi']);
            exit;
        }

        if ($price <= 0) {
            echo json_encode(['success' => false, 'message' => 'Harga harus lebih dari 0']);
            exit;
        }

        if ($stock < 0) {
            echo json_encode(['success' => false, 'message' => 'Stok tidak boleh negatif']);
            exit;
        }

        // Upload Image
        $image = 'uploads/products/default.jpg';
        if (!empty($_FILES['image']['name'])) {
            $dir = '../../uploads/products/';
            if (!is_dir($dir)) mkdir($dir, 0777, true);

            $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
            $allow = ['jpg','jpeg','png','gif'];
            $maxSize = 2 * 1024 * 1024; // 2MB

            if (!in_array($ext, $allow)) {
                echo json_encode(['success' => false, 'message' => 'Format gambar tidak didukung. Gunakan JPG, PNG, atau GIF']);
                exit;
            }

            if ($_FILES['image']['size'] > $maxSize) {
                echo json_encode(['success' => false, 'message' => 'Ukuran gambar terlalu besar. Maksimal 2MB']);
                exit;
            }

            $file = uniqid().'_'.$name.'.'.$ext;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $dir.$file)) {
                $image = 'uploads/products/'.$file;
            } else {
                echo json_encode(['success' => false, 'message' => 'Gagal upload gambar']);
                exit;
            }
        }

        $stmt = $db->prepare("
            INSERT INTO products 
            (name, description, price, stock, category, image, is_active, total_sold, created_at)
            VALUES (:n,:d,:p,:s,:c,:i,1,0,NOW())
        ");
        $stmt->execute([
            ':n'=>$name, ':d'=>$description, ':p'=>$price,
            ':s'=>$stock, ':c'=>$category, ':i'=>$image
        ]);

        echo json_encode(['success'=>true, 'message'=>'Produk berhasil ditambahkan']);
        exit;
    }

    /* ===================== EDIT ===================== */
    if ($action === 'edit') {

        $id = intval($_POST['id'] ?? 0);
        if ($id <= 0) throw new Exception('ID tidak valid');

        $name        = trim($_POST['name'] ?? '');
        $description = trim($_POST['description'] ?? '');
        $price       = isset($_POST['price']) ? floatval($_POST['price']) : 0;
        $stock       = isset($_POST['stock']) ? intval($_POST['stock']) : 0;
        $category    = trim($_POST['category'] ?? '');

        if ($name === '' || $description === '' || $category === '') {
            throw new Exception('Nama, deskripsi, dan kategori harus diisi');
        }

        if ($price <= 0) {
            throw new Exception('Harga harus lebih dari 0');
        }

        if ($stock < 0) {
            throw new Exception('Stok tidak boleh negatif');
        }

        $stmt = $db->prepare("SELECT image FROM products WHERE id=?");
        $stmt->execute([$id]);
        $current = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$current) throw new Exception('Produk tidak ditemukan');

        $image = $current['image'];

        if (!empty($_FILES['image']['name'])) {
            $dir = '../../uploads/products/';
            if (!is_dir($dir)) mkdir($dir, 0777, true);

            $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
            $allow = ['jpg','jpeg','png','gif'];
            $maxSize = 2 * 1024 * 1024; // 2MB

            if (!in_array($ext, $allow)) {
                throw new Exception('Format gambar tidak didukung. Gunakan JPG, PNG, atau GIF');
            }

            if ($_FILES['image']['size'] > $maxSize) {
                throw new Exception('Ukuran gambar terlalu besar. Maksimal 2MB');
            }

            $file = uniqid().'_'.$id.'.'.$ext;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $dir.$file)) {
                // Delete old image if not default
                if ($current['image'] !== 'uploads/products/default.jpg' && file_exists('../../'.$current['image'])) {
                    unlink('../../'.$current['image']);
                }
                $image = 'uploads/products/'.$file;
            } else {
                throw new Exception('Gagal upload gambar');
            }
        }

        $stmt = $db->prepare("
            UPDATE products SET
            name=:n, description=:d, price=:p, stock=:s, category=:c, image=:i
            WHERE id=:id
        ");
        $stmt->execute([
            ':n'=>$name, ':d'=>$description,
            ':p'=>$price, ':s'=>$stock,
            ':c'=>$category, ':i'=>$image, ':id'=>$id
        ]);

        echo json_encode(['success'=>true, 'message'=>'Produk berhasil diupdate']);
        exit;
    }

    /* ===================== DELETE ===================== */
    if ($action === 'delete') {

        $id = intval($_POST['id'] ?? 0);
        if ($id <= 0) throw new Exception('ID tidak valid');

        $stmt = $db->prepare("SELECT image FROM products WHERE id=?");
        $stmt->execute([$id]);
        $product = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$product) throw new Exception('Produk tidak ditemukan');

        // Delete image file if not default
        if ($product['image'] !== 'uploads/products/default.jpg' && file_exists('../../'.$product['image'])) {
            unlink('../../'.$product['image']);
        }

        $stmt = $db->prepare("DELETE FROM products WHERE id=?");
        $stmt->execute([$id]);

        echo json_encode(['success'=>true, 'message'=>'Produk berhasil dihapus']);
        exit;
    }

    echo json_encode(['success'=>false,'message'=>'Action tidak valid']);

} catch (Exception $e) {
    echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
}
