<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

require_once '../../backend_api/config/database.php';
$database = new Database();
$db = $database->getConnection();

$order_id = isset($_POST['order_id']) ? $_POST['order_id'] : 0;
$action = isset($_POST['action']) ? $_POST['action'] : 'verify';

if (!$order_id) {
    echo json_encode(['success' => false, 'message' => 'Order ID tidak valid']);
    exit;
}

try {
    $db->beginTransaction();
    
    if ($action === 'verify') {
        // Update payment status
        $query = "UPDATE payments SET 
                  status = 'verified'
                  WHERE order_id = :order_id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':order_id', $order_id);
        $stmt->execute();
        
        // Update order status to diproses if still pending
        $order_query = "UPDATE orders SET status = 'processing' WHERE id = :order_id AND status = 'pending'";
        $order_stmt = $db->prepare($order_query);
        $order_stmt->bindParam(':order_id', $order_id);
        $order_stmt->execute();
        
        $db->commit();
        echo json_encode(['success' => true, 'message' => 'Pembayaran berhasil diverifikasi']);
        
    } else if ($action === 'reject') {
        // Reject payment
        $query = "UPDATE payments SET 
                  status = 'rejected'
                  WHERE order_id = :order_id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':order_id', $order_id);
        $stmt->execute();
        
        // Cancel order
        $order_query = "UPDATE orders SET status = 'cancelled' WHERE id = :order_id";
        $order_stmt = $db->prepare($order_query);
        $order_stmt->bindParam(':order_id', $order_id);
        $order_stmt->execute();
        
        $db->commit();
        echo json_encode(['success' => true, 'message' => 'Pembayaran ditolak dan pesanan dibatalkan']);
        
    } else {
        $db->rollBack();
        echo json_encode(['success' => false, 'message' => 'Aksi tidak valid']);
    }
    
} catch (PDOException $e) {
    $db->rollBack();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
